% Generated by roxygen2 (4.0.2): do not edit by hand
\name{allocations}
\alias{allocations}
\title{Teitz-Bart algorithm applied to Spatial* and Spatial*DataFrame objects}
\usage{
allocations(swdf1, swdf2, force, p, metric, verbose = FALSE)
}
\arguments{
\item{swdf1}{- first Spatial* or Spatial*DataFrame objects}

\item{swdf2}{- second Spatial* or Spatial*DataFrame objects (if omitted,  defaults to the same value as \code{swdf1})}

\item{force}{- list of supply points or logical vector with length the same as the number of supply points that are forced to be used - eg e}

\item{p}{- either a guess at the initial \eqn{p}-median set of a single integer indicating the size of the set (which is then chosen randomly)}

\item{metric}{- the distance matrix (defaults to Euclidean computed via \code{euc.dists(swdf1,swdf2)} if not supplied)}

\item{verbose}{- if TRUE print out each swap in the algorithm (default is FALSE)}
}
\value{
Copy of swdf1 with extra data columns called \code{allocation} and \code{allocdist}
with indices for each element from the \eqn{p}-median set
}
\description{
Return demand Spatial*Dataframe with new columns giving allocation id and distance to supply point
}
\examples{
require(RColorBrewer)
require(GISTools)
data(georgia)
georgia3 <- allocations(georgia2,p=5,force=c(1,120,44))
col.index <- match(georgia3$allocation,unique(georgia3$allocation))
col.alloc <- brewer.pal(5,'Accent')[col.index]
par(mfrow=c(1,2))
plot(georgia3,col=col.alloc)
choropleth(georgia3,georgia3$allocdist)


# Use in conjunction with rgeos
require(rgeos)
require(GISTools)
georgia3 <- allocations(georgia2,p=5,force=c(1,120,44))
georgia4 <- gUnaryUnion(georgia3,georgia3$allocation)
plot(georgia4)
plot(star.diagram(georgia3),col='darkred',lwd=2,add=TRUE)
}

