% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_traits.R
\name{taxon_traits}
\alias{taxon_traits}
\alias{taxon_traits,taxlist-method}
\alias{taxon_traits<-}
\alias{taxon_traits<-,taxlist,data.frame-method}
\alias{update_trait}
\alias{update_trait,taxlist,numeric-method}
\title{Manipulation of taxon traits in taxlist objects.}
\usage{
taxon_traits(taxlist, ...)

\S4method{taxon_traits}{taxlist}(taxlist, ...)

taxon_traits(taxlist) <- value

\S4method{taxon_traits}{taxlist,data.frame}(taxlist) <- value

update_trait(taxlist, ConceptID, ...)

\S4method{update_trait}{taxlist,numeric}(taxlist, ConceptID, ...)
}
\arguments{
\item{taxlist}{A \linkS4class{taxlist} object.}

\item{...}{Further arguments to be passed among methods.}

\item{value}{Data frame to be set as slot \code{taxonTraits}.}

\item{ConceptID}{A numeric vector with the respective taxon concept IDs.}
}
\description{
The slot \code{taxonTraits} in \linkS4class{taxlist} objects contains
attributes of taxon concepts (e.g. functional traits).
These functions are suitable for replacing, retrieving and appending trait
information in taxonomic lists.
}
\details{
Taxon traits are contained in a data frame at the slot \code{taxonTraits} in
\linkS4class{taxlist} objects.
To optimise space, this data frame contain only entries for those concepts
with information, while taxa with no information are skipped from this table.
Thus appending new variables may also have to include new rows in this slot,
which is automatically carried out by this function.

The replacement method \verb{taxon_traits<-} should be only used when
constructing \linkS4class{taxlist} objects from an empty one.
}
\examples{
head(taxon_traits(Easplist))

## Updating traits for Launaea cornuta
summary(Easplist, "Launaea cornuta")
accepted_name(taxlist=Easplist, ConceptID=355, show_traits=TRUE)

# Update
Easplist <- update_trait(taxlist=Easplist, ConceptID=355,
    lf_behn_2018="annual")
accepted_name(taxlist=Easplist, ConceptID=355, show_traits=TRUE)

}
\seealso{
\linkS4class{taxlist}.
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
