# clade <- rank_ref[NROW(rank_ref), ]
# clade$ranks <- paste0(clade$ranks, ",clade")
# rank_ref <- rbind(rank_ref[-NROW(rank_ref), ], clade)
# rank_ref

# cohorts <- c("megacohort", "supercohort", "cohort", "subcohort", "infracohort")
# cohort_ids <- c()

# -----------------
ids <- c(
  '01', # domain
  '05','10','20','25', # kingdom
  '30','40','45', # phylum/division
  '50','60','70','80','81','82', # class
  '83','84','85','86','87', # cohort
  '90','100','110','120','125', # order
  '130','140','150', # family
  '155','160','170', # tribe
  '180','190','200','210','215','217', # genus
  '220','225','230', # species/etc.
  '240','250','255','260','265','270', # variety/sub/form/etc.
  '300' # unspecified
)
ranks <- c(
  'domain', # domain
  'superkingdom','kingdom','subkingdom','infrakingdom,superphylum', # kingdom
  'phylum,division','subphylum,subdivision','infradivision', # phylum/division
  'superclass','class','subclass','infraclass','subterclass','parvclass', # class
  'megacohort','supercohort','cohort','subcohort','infracohort', # cohort
  'superorder','order','suborder','infraorder','parvorder', # order
  'superfamily','family','subfamily', # family
  'supertribe','tribe','subtribe', # tribe
  'genus','subgenus','section','subsection','species group','species subgroup', # genus
  'species','infraspecies','subspecies', # species/etc.
  'variety,varietas','subvariety,race','stirp','form,forma,morph','aberration','subform', # variety/sub/form/etc.
  'unspecified,no rank,unranked,clade' # unspecified
)
rank_ref <- data.frame(
  rankid = ids,
  ranks = ranks,
  stringsAsFactors = FALSE
)
save(rank_ref, file = "data/rank_ref.RData", version = 2)

# NOTE: "version = 2" is so that we don't have to require R > 3.5
