% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progressor.R
\name{progressor}
\alias{progressor}
\title{methods for preparing/printing info for prompts for \verb{get_*} functions}
\description{
methods for preparing/printing info for prompts for \verb{get_*} functions

methods for preparing/printing info for prompts for \verb{get_*} functions
}
\examples{
\dontrun{
# nms <- c("Quercus", "Sasdsfasdf")
# x <- progressor$new(items = nms)
# x
# x$prog_start()

# x$completed(nms[1], "found")
# x$prog_found()

# x$completed(nms[2], "not found")
# x$prog_not_found()

# x$prog_summary()

# suppress cli::cat_line
# x <- progressor$new(items = nms, suppress = TRUE)
# x$prog_summary()
}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{total}}{(integer) x}

\item{\code{found}}{(integer) list of results when name found}

\item{\code{not_found}}{(integer) list of results when name not found}

\item{\code{done}}{(integer) x}

\item{\code{suppress}}{(integer) x}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{p}}{(integer) percent done}

\item{\code{d}}{(integer) number done}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{progressor$new()}}
\item \href{#method-completed}{\code{progressor$completed()}}
\item \href{#method-completed_found}{\code{progressor$completed_found()}}
\item \href{#method-completed_not_found}{\code{progressor$completed_not_found()}}
\item \href{#method-prog_start}{\code{progressor$prog_start()}}
\item \href{#method-prog}{\code{progressor$prog()}}
\item \href{#method-prog_found}{\code{progressor$prog_found()}}
\item \href{#method-prog_not_found}{\code{progressor$prog_not_found()}}
\item \href{#method-prog_summary}{\code{progressor$prog_summary()}}
\item \href{#method-clone}{\code{progressor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{progressor} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{progressor$new(items, suppress = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{items}}{(character) xxx}

\item{\code{suppress}}{(logical) suppress messages. default: \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{progressor} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-completed"></a>}}
\subsection{Method \code{completed()}}{
add results to found or not found
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{progressor$completed(name, att)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(character) vector of names}

\item{\code{att}}{(character) one of "found" or "not found"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned; adds to \verb{$found} or \verb{$not_found}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-completed_found"></a>}}
\subsection{Method \code{completed_found()}}{
add to found results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{progressor$completed_found(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(character) vector of taxon names}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned; adds to \verb{$found}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-completed_not_found"></a>}}
\subsection{Method \code{completed_not_found()}}{
add to not found results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{progressor$completed_not_found(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(character) vector of taxon names}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned; adds to \verb{$not_found}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-prog_start"></a>}}
\subsection{Method \code{prog_start()}}{
print messages of total queries to do, and
percent completed
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{progressor$prog_start()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-prog"></a>}}
\subsection{Method \code{prog()}}{
prints message of found or not found using packages
cli and crayon
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{progressor$prog(att)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{att}}{(character) one of "found" or "not found"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
messages
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-prog_found"></a>}}
\subsection{Method \code{prog_found()}}{
prints found message using packages cli and crayon
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{progressor$prog_found()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
messages
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-prog_not_found"></a>}}
\subsection{Method \code{prog_not_found()}}{
prints not found message using packages cli and crayon
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{progressor$prog_not_found()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
messages
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-prog_summary"></a>}}
\subsection{Method \code{prog_summary()}}{
prints summary at end of result with total found and
not found
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{progressor$prog_summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
messages
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{progressor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
