% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iucn_summary.R
\name{iucn_summary}
\alias{iucn_status.iucn}
\alias{iucn_summary}
\alias{iucn_summary_id}
\title{Get a summary from the IUCN Red List}
\usage{
iucn_summary(sciname, silent = TRUE, parallel = FALSE,
  distr_detail = FALSE, ...)

iucn_summary_id(species_id, silent = TRUE, parallel = FALSE,
  distr_detail = FALSE, ...)

\method{iucn_status}{iucn}(x, ...)
}
\arguments{
\item{sciname}{character; Scientific name. Should be cleaned and in the
format \emph{<Genus> <Species>}.}

\item{silent}{logical; Make errors silent or not (when species not found).}

\item{parallel}{logical; Search in parallel to speed up search. You have to
register a parallel backend if \code{TRUE}. See e.g., doMC, doSNOW, etc.}

\item{distr_detail}{logical; If \code{TRUE}, the geographic distribution is
returned as a list of vectors corresponding to the different range types: 
native, introduced, etc.}

\item{...}{Currently not used.}

\item{species_id}{an IUCN ID}

\item{x}{an \code{iucn} object as returned by
\code{\link[taxize]{iucn_summary}}.}
}
\value{
A list (for every species one entry) of lists with the following
items:
\item{status}{Red List Category.}
\item{history}{History of status, if available.}
\item{distr}{Geographic distribution, if available.}
\item{trend}{Trend of population size, if available.}
}
\description{
Get a summary from the IUCN Red List (\url{http://www.iucnredlist.org/}).
}
\details{
Beware: IUCN functions can give back incorrect data. This isn't our fault.
We do our best to get you the correct data quickly, but sometimes IUCN gives
back the wrong data, and sometimes Global Names gives back the wrong data.
We will fix these as soon as possible. In the meantime, just make sure that
the data you get back is correct.
}
\note{
Not all entries (history, distr, trend) are available for every species
and NA is returned.
\code{\link[taxize]{iucn_status}} is an extractor function to easily extract
status into a vector.
}
\examples{
\dontrun{
ia <- iucn_summary(c("Panthera uncia", "Lynx lynx"))
ia <- iucn_summary(c("Panthera uncia", "Lynx lynx", "aaa"))
# get summary from IUCN ID
ia <- iucn_summary_id(c(22732, 12519))
# extract status
iucn_status(ia)
# extract other available information
ia[['Lynx lynx']]$history
ia[['Panthera uncia']]$distr
ia[[2]]$trend
# get detailed distribution
iac <- iucn_summary("Ara chloropterus", distr_detail = TRUE)
iac[[1]]$distr 
}


}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}

Philippe Marchand, \email{marchand.philippe@gmail.com}
}
\seealso{
\code{\link[taxize]{iucn_status}}
}

