% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tl_provenance.R
\name{tl_provenance}
\alias{tl_provenance}
\title{Provenance information for taxalight data sources}
\usage{
tl_provenance(
  url = paste0("https://raw.githubusercontent.com/",
    "boettiger-lab/taxadb-cache/master/prov.json")
)
}
\arguments{
\item{url}{The location of the most recent provenance record.  Leave as default.}
}
\value{
A data frame summarizing the available processed data, along with
identifiers that can be resolved by \code{\link[contentid:resolve]{contentid::resolve()}}.
}
\description{
\code{tl_provenance} parses a JSON-LD file describing the data provenance between
the original source data and standardized tables imported by \code{taxalight} and
\code{taxadb} R packages.  The JSON-LD markup is specified using the DCAT2 and
PROV namespaces, which is parsed and returned as a simple data.frame structure.
}
\details{
All content (source data, scripts, and processed tables) are referenced by
content-based identifiers (see \code{\link[contentid:content_id]{contentid::content_id()}}), which provide automatic
caching of downloads and cryptographic certainty that a version has not been altered.
Rather than list a single download URL as the access point, content identifiers
can be resolves (see \code{\link[contentid:resolve]{contentid::resolve()}}) to any of multiple sources which
provide the identical content.  This makes them more robust to link rot, much
like a DOI.
}
