% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{leaves_apply}
\alias{leaves_apply}
\title{Apply function to leaves of each taxon}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object containing taxon
information to be queried.}

\item{func}{(\code{function}) The function to apply.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes to use.
Default: All taxa in \code{obj} will be used. Any variable name that appears in
\code{\link[=all_names]{all_names()}} can be used as if it was a vector on its own.}

\item{recursive}{(\code{logical} or \code{numeric}) If \code{FALSE}, only return the
leaves if they occur one rank below the target taxa. If \code{TRUE}, return all of the
leaves for each taxon. Positive numbers indicate the number of
recursions (i.e. number of ranks below the target taxon to return). \code{1} is
equivalent to \code{FALSE}. Negative numbers are equivalent to \code{TRUE}.}

\item{simplify}{(\code{logical}) If \code{TRUE}, then combine all the results into a
single vector of unique values.}

\item{value}{What data to give to the function. Any result of
\code{all_names(obj)} can be used, but it usually only makes sense to use data
that has an associated taxon id.}

\item{...}{Extra arguments are passed to the function \code{func}.}
}
\description{
Apply a function to the leaves of each taxon. This is similar
to using \code{\link[=leaves]{leaves()}} with \code{\link[=lapply]{lapply()}} or \code{\link[=sapply]{sapply()}}.
\preformatted{
obj$leaves_apply(func, subset = NULL, recursive = TRUE,
  simplify = FALSE, value = "taxon_indexes", ...)
leaves_apply(obj, func, subset = NULL, recursive = TRUE,
  simplify = FALSE, value = "taxon_indexes", ...)}
}
\examples{
# Count number of leaves under each taxon or its subtaxa
leaves_apply(ex_taxmap, length)

# Count number of leaves under each taxon
leaves_apply(ex_taxmap, length, recursive = FALSE)

# Converting output of leaves to upper case
leaves_apply(ex_taxmap, value = "taxon_names", toupper)

# Passing arguments to the function
leaves_apply(ex_taxmap, value = "taxon_names", paste0, collapse = ", ")

}
