% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span.R
\name{span}
\alias{span}
\title{Span taxa}
\usage{
span(.data, ...)
}
\arguments{
\item{.data}{Input, object of class \code{Hierarchy}, or \code{hierarchies}}

\item{...}{quoted rank names (e.g., family) via \code{\link[=ranks]{ranks()}}, taxon names
(e.g., Poa annua) via \code{\link[=nms]{nms()}}, or taxonomic IDs (e.g., 93036) via \code{\link[=ids]{ids()}}.
You can't pass in arbitrary strings or numbers.}
}
\value{
an object of the same class as passed in
}
\description{
Select a range of taxa, either by two names, or relational
operators
}
\details{
supports \code{Hierarchy} and \code{hierarchies} objects
}
\examples{
# Hierarchy class
ex_hierarchy1

## ranks
### keep all taxa between family and genus
span(ex_hierarchy1, ranks("family", "genus"))
span(ex_hierarchy1, nms("Poaceae", "Poa"))
span(ex_hierarchy1, ids(4479, 4544))

### keep all taxa between genus and species
span(ex_hierarchy1, ranks("genus", "species"))

### keep all taxa greater than genus
span(ex_hierarchy1, ranks("> genus"))

### keep all taxa greater than or equal to genus
span(ex_hierarchy1, ranks(">= genus"))

### keep all taxa less than genus
span(ex_hierarchy1, ranks("< genus"))

### keep all taxa less than or equal to genus
span(ex_hierarchy1, ranks("<= genus"))

### same as above, with different dataset
span(ex_hierarchy2, ranks("> genus"))
span(ex_hierarchy2, ranks(">= genus"))
span(ex_hierarchy2, ranks("< genus"))
span(ex_hierarchy2, ranks("<= genus"))

# using taxonomic names
span(ex_hierarchy2, nms("< Felidae"))

# using taxonomic ids
span(ex_hierarchy2, ids("< 9681"))

## Multiple operator statements - useful with larger classifications
ex_hierarchy3
span(ex_hierarchy3, ranks("> genus"), ranks("< phylum"))
span(ex_hierarchy3, ids("> 161994"), ids("< 158852"))


## taxon names
### keep all taxa between Poaceae and Poa
### - matches to ranks first
ex_hierarchy1 \%>\% span(nms("Poaceae", "Poa"))

## taxon ids
### keep all taxa between 4479 and 4544 taxonomic IDs
### - matches to ranks first
ex_hierarchy1 \%>\% span(ids(4479, 4544))


# hierarchies class
invisible(lapply(ex_hierarchies, print))
ex_hierarchies \%>\% span(ranks("family", "genus")) \%>\% lapply(., print) \%>\%
invisible
}
\seealso{
See \link{filtering-helpers}, including for more explanation
of how this function works.
}
