% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_helper.R
\name{tar_helper}
\alias{tar_helper}
\title{Write a helper R script.}
\usage{
tar_helper(path = NULL, code = NULL, tidy_eval = TRUE, envir = parent.frame())
}
\arguments{
\item{path}{Character of length 1, path to write (or overwrite) \code{code}.
If the parent directory does not exist, \code{tar_helper_raw()} creates it.}

\item{code}{Quoted code to write to \code{path}.
\code{tar_helper()} overwrites the file if it already exists.}

\item{tidy_eval}{Logical, whether to use tidy evaluation on \code{code}. If
turned on, you can substitute expressions and symbols using \verb{!!} and \verb{!!!}.
See examples below.}

\item{envir}{Environment for tidy evaluation.}
}
\value{
\code{NULL} (invisibly)
}
\description{
Write a helper R script for a \code{targets} pipeline.
Could be supporting functions or the \verb{_targets.R} file itself.
}
\details{
\code{tar_helper()} is a specialized version of \code{\link[=tar_script]{tar_script()}}
with flexible paths and tidy evaluation.
}
\examples{
# Without tidy evaluation:
path <- tempfile()
tar_helper(path, x <- 1)
writeLines(readLines(path))
# With tidy evaluation:
y <- 123
tar_helper(path, x <- !!y)
writeLines(readLines(path))
}
\seealso{
Other scripts: 
\code{\link{tar_edit}()},
\code{\link{tar_github_actions}()},
\code{\link{tar_helper_raw}()},
\code{\link{tar_renv}()},
\code{\link{tar_script}()}
}
\concept{scripts}
