% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_sub.R
\name{tar_sub}
\alias{tar_sub}
\title{Create multiple expressions with symbol substitution.}
\usage{
tar_sub(expr, values)
}
\arguments{
\item{expr}{Starting expression. Values are iteratively substituted
in place of symbols in \code{expr} to create each new expression.}

\item{values}{List of values to substitute into \code{expr} to create
the expressions. All elements of \code{values} must have the same length.}
}
\value{
A list of expression objects. Often, these expression objects
evaluate to target objects (but not necessarily).
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please see the design specification at
\url{https://books.ropensci.org/targets-design/}
to learn about the structure and composition of target objects.
}
\description{
Loop over a grid of values and create an expression object
from each one. Helps with general metaprogramming.
}
\examples{
# tar_map() is incompatible with tar_render() because the latter
# operates on preexisting tar_target() objects. By contrast,
# tar_eval() and tar_sub() iterate over code farther upstream.
values <- list(
  name = lapply(c("name1", "name2"), as.symbol),
  file = list("file1.Rmd", "file2.Rmd")
)
tar_sub(tar_render(name, file), values = values)
}
