% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-hmisc.R
\docType{data}
\name{hmisc_p}
\alias{hmisc_p}
\alias{hmisc_iqr}
\alias{hmisc_fraction}
\alias{hmisc_fstat}
\alias{hmisc_chi2}
\alias{hmisc_spearman}
\alias{hmisc_wilcox}
\alias{hmisc_cell}
\title{Cell Generation functions for hmisc default}
\format{
An object of class \code{list} of length 8.
}
\usage{
hmisc_p(p, pformat = "\%1.3f", include_p = TRUE)

hmisc_iqr(
  x,
  format = NA,
  na.rm = TRUE,
  names = FALSE,
  type = 8,
  msd = FALSE,
  quant = c(0.25, 0.5, 0.75),
  ...
)

hmisc_fraction(numerator, denominator, format = 3, ...)

hmisc_fstat(f, df1, df2, p, class = NULL, ...)

hmisc_chi2(chi2, df, p, class = NULL, ...)

hmisc_spearman(S, rho, p, class = NULL, ...)

hmisc_wilcox(V, p, class = NULL, ...)

hmisc_cell
}
\arguments{
\item{p}{numeric; p-value to format}

\item{pformat}{numeric or character; Significant digits or fmt to pass to sprintf}

\item{include_p}{logical; include the leading P on the output string}

\item{x}{numeric; whose sample quantiles are wanted. NA and NaN values are not allowed in numeric vectors unless na.rm is TRUE.}

\item{format}{numeric or character; Significant digits or fmt to pass to sprintf}

\item{na.rm}{logical; if true, any NA and NaN's are removed from x before the quantiles are computed.}

\item{names}{logical; if true, the result has a names attribute. Set to FALSE for speedup with many probs.}

\item{type}{integer; specify algorithm to use in constructing quantile. See quantile for more information.}

\item{msd}{logical; compute an msd attribute containing mean and standard deviation}

\item{quant}{numeric; The quantiles to display. Should be an odd length vector, since the center value is highlighted.}

\item{...}{additional arguments passed}

\item{numerator}{numeric; The value of the numerator}

\item{denominator}{numeric; The value of the denominator}

\item{f}{The value of the f-statistic}

\item{df1}{1st dimension degrees of freedom}

\item{df2}{2nd dimension degrees of freedom}

\item{class}{character; An optional field for additional S3 classes (e.g. could be used in html rendering for CSS)}

\item{chi2}{The value of the X^2 statistic}

\item{df}{degrees of freedom}

\item{S}{The value of the spearman statistic}

\item{rho}{The rho value of the test}

\item{V}{The value of the Wilcoxon statistic}
}
\value{
A formatted string or cell as appropriate
}
\description{
Each function here is called when a cell is generated. Overriding these in a formula call will allows
one to customize exactly how each cell's contents are generated.
While this serves as the base template for transforms, it is by no means required if one develops their
own bundle of data transforms. One can create ay number of cell level styling choices.
}
\section{\code{hmisc_p}}{

Given a style in number of digits or a sprintf style specifier it renders
the p-value and checks to see if it's all zeros, then switches the
output to a less than.
}

\section{\code{hmisc_iqr}}{

Construct a cell which has the interquartile ranges specified.
}

\section{\code{hmisc_fraction}}{

Construct a cell which has the fraction specified in an hmisc format
}

\section{\code{hmisc_fstat}}{

Construct a cell which has the fstat specified in an hmisc format.
}

\section{\code{hmisc_chi2}}{

Construct a cell which has the chi^2 specified in an hmisc format
}

\section{\code{hmisc_spearman}}{

Construct a cell which has the spearman specified in an hmisc format
}

\section{\code{hmisc_wilcox}}{

Construct a cell which has the Wilcoxon specified in an hmisc format
}

\section{\code{hmisc_cell}}{

List of data transforms for a cell of a table.

\preformatted{
hmisc_cell <- list(
  n        = cell_n,
  iqr      = hmisc_iqr,
  fraction = hmisc_fraction,
  fstat    = hmisc_fstat,
  chi2     = hmisc_chi2,
  spearman = hmisc_spearman,
  wilcox   = hmisc_wilcox,
  p        = hmisc_p
)}
}

\examples{
hmisc_p(1e-6)
hmisc_p(0.234)
hmisc_p(1.234e-6, 5)
hmisc_p(1.234e-6, 6)
require(stats)
hmisc_iqr(rnorm(100), '3')
hmisc_fraction(1, 4, 3)
hmisc_fstat(4.0, 10, 20, 0.004039541)
hmisc_chi2(5.33, 6, 0.2)
hmisc_spearman(20, 0.2, 0.05)
hmisc_wilcox(20, 0.2)
}
\seealso{
\code{\link{hmisc}}
}
\keyword{data}
