% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagr.r
\name{rm_bytag}
\alias{rm_bytag}
\title{Remove Objects by Tag}
\usage{
rm_bytag(
  tag,
  envir = parent.frame(),
  confirm = getOption("tagsr.confirm", FALSE)
)
}
\arguments{
\item{tag}{The tag to search for.}

\item{envir}{The environment to search in. Defaults to the current environment.}

\item{confirm}{If \code{TRUE}, a confirmation prompt will be displayed before objects are deleted.}
}
\value{
No return value.
}
\description{
Remove all objects in the current environment that have a specified tag.
}
\examples{
# create some objects with tags
x <- 1:10
y <- matrix(rnorm(16), 4, 4)
add_tags(x, "numbers")
add_tags(y, "matrix")

# remove all objects with the "numbers" tag
rm_bytag("numbers")

# remove all objects with the "matrix" tag without confirmation prompt
set_confirm(FALSE)
rm_bytag("matrix")

# confirm that objects have been removed
ls()

# clean up
rm(set_confirm, x, y)

}
\seealso{
\code{\link{add_tags}}, \code{\link{has_tag}}, \code{\link{ls_bytag}}
}
