% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_helpers.R
\name{tadaa_likertize}
\alias{tadaa_likertize}
\title{Easily cluster numeric vectors in likert-like classes}
\usage{
tadaa_likertize(x, classes = 3, method = "quantiles")
}
\arguments{
\item{x}{Vector to be clustered.}

\item{classes}{Number of classes. Defaults to 3, can also be 5.}

\item{method}{How should the classes be calculated? Defaults to \code{quantiles}, can also be
\code{means} for mean and standard deviation.}
}
\value{
An ordered \code{factor} with \code{classes} levels. And descriptive labels.
}
\description{
Easily cluster numeric vectors in likert-like classes
}
\examples{
tadaa_likertize(x = runif(100, 0, 10), classes = 3, method = "quantiles")
tadaa_likertize(x = runif(100, 0, 10), classes = 3, method = "meansd")
}

