% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_xl.R
\name{tab_xl}
\alias{tab_xl}
\title{Excel output for tabxplor tables, with formatting and colors}
\usage{
tab_xl(
  tabs,
  path = NULL,
  replace = FALSE,
  open = rlang::is_interactive(),
  colnames_rotation = 0,
  remove_tab_vars = TRUE,
  colwidth = "auto",
  print_ci = FALSE,
  print_color_legend = TRUE,
  sheets = "tabs",
  n_min = 0,
  titles,
  hide_near_zero = "auto",
  color_type = "text"
)
}
\arguments{
\item{tabs}{A table made with \code{\link{tab}}, \code{\link{tab_many}} or
\code{\link{tab_plain}}, or a list of such tables.}

\item{path, replace, open}{The name, and possibly the path, of the Excel file to
create (possibly without the .xlsx extension). Default path to temporary directory.
Set global option \code{"tabxplor.export_dir"} with \code{link[base:options]{options}}
to change default directory. By default replace is \code{TRUE} when \code{path} is provided,
\code{FALSE} when \code{path} is not provided.
Use \code{replace = TRUE} to overwrite existing files. Use \code{open = FALSE}
if you don't want to automatically open the tables in Excel (or another
software associated with .xlsx files).}

\item{colnames_rotation}{Rotate the names of columns to an angle (in degrees).}

\item{remove_tab_vars}{By default, \code{tab_vars} columns are removed to gain space.
Set to \code{FALSE} to keep them.}

\item{colwidth}{The standard width for numeric columns, as a number.
Default to \code{"auto"}.}

\item{print_ci}{Set to \code{TRUE} to print confidence intervals in another table,
at the left of the base table.}

\item{print_color_legend}{Should the color legends be printed with the subtexts ?}

\item{sheets}{The Excel sheets options :
\itemize{
\item \code{"tabs"}: a new sheet is created for each table
\item \code{"unique"}: all tables are on the same sheet
\item \code{"auto"}: subsequent tables with the same columns are printed on the
same sheets
}}

\item{n_min}{The total count under which a column or row is turned pale grey
because there is not enough observation for it to be significant.
Default to 0 (not used).}

\item{titles}{The titles of the different tables, as a character vector. When missing
titles are given based on the names of the variables.}

\item{hide_near_zero}{By default all cells displayed as 0 (even rounded)
turn pale grey, to make the distribution of empty cells (and other cells) more visible.
Provide a number to turn grey every cell below it. Set to \code{Inf} not to use
this feature.}

\item{color_type}{By default, the text is colored. Set to \code{"bg"} to color
the background instead.}
}
\value{
The table(s) with formatting and colors in an Excel file, as a side effect.
Invisibly returns \code{tabs}.
}
\description{
To modify the colors used into the Excel table, you can change the
global options with \code{\link{set_color_style}} and \code{\link{set_color_breaks}}.
}
\examples{
\donttest{
forcats::gss_cat \%>\%
  tab(marital, race, pct = "row", color = "diff") \%>\%
  tab_xl()
  }
}
