% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plotRank}
\alias{plotRank}
\alias{plotRank-method}
\alias{plotRank,CountMatrix-method}
\alias{plotRank,FrequencyMatrix-method}
\title{Rank vs abundance plot}
\usage{
plotRank(object, ...)

\S4method{plotRank}{CountMatrix}(object, log = NULL, facet = TRUE)

\S4method{plotRank}{FrequencyMatrix}(object, log = NULL, facet = TRUE)
}
\arguments{
\item{object}{An object to be plotted.}

\item{...}{Further arguments passed to other methods.}

\item{log}{A \code{\link{character}} string which contains "\code{x}" if the
x axis is to be logarithmic, "\code{y}" if the y axis is to be logarithmic
and "\code{xy}" or "\code{yx}" if both axes are to be logarithmic (base 10).}

\item{facet}{A \code{\link{logical}} scalar: should a matrix of panels
defined by case/sample be drawn?}
}
\description{
Plots a rank \emph{vs} relative abundance diagram.
}
\details{
Note that rows are scaled to 0-1 (frequencies).
}
\examples{
# Coerce dataset to abundance matrix
# Data from Desachy 2004
count <- as(compiegne, "CountMatrix")
freq <- as(boves, "FrequencyMatrix")

# Plot rank vs abundance
plotRank(count)
plotRank(count, log = "xy")

# Plot rank vs abundance
plotRank(freq, facet = FALSE)
plotRank(freq, facet = FALSE, log = "xy")
}
\seealso{
Other plot: \code{\link{plotBar}}, \code{\link{plotDate}},
  \code{\link{plotMatrix}}, \code{\link{plotSpot}}
}
\author{
N. Frerebeau
}
\concept{plot}
