% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/extract.R
\docType{class}
\name{BootCA-class}
\alias{BootCA-class}
\alias{[[,BootCA-method}
\alias{[,BootCA-method}
\title{Partial bootstrap CA}
\usage{
\S4method{[[}{BootCA}(x, i)

\S4method{[}{BootCA}(x, i, j)
}
\arguments{
\item{x}{A \code{BootCA} object from which to extract element(s).}

\item{i, j}{Indices specifying elements to extract.
\code{i} is a \code{\link{character}} string matching to the name of a slot.
\code{j} can be \code{\link{missing}} or \code{\link{NULL}},
a \code{\link{numeric}} or \code{\link{character}} vector.
Numeric values are coerced to \code{\link{integer}} as by
\code{\link{as.integer}} (and hence truncated towards zero).
Character vectors will be matched to the names of the object.}
}
\description{
An S4 class to store partial bootstrap correspondance analysis results.
}
\section{Methods (by generic)}{
\itemize{
\item \code{[[}: Extracts informations from a slot selected by subscript
\code{i}.

\item \code{[}: Allows to select a slot thru \code{j}.
}}

\section{Slots}{

\describe{
\item{\code{rows}}{A three columns \code{\link{data.frame}} giving the vertices
coordinates of the samples convex hull and a identifier to link each row to
a sample.}

\item{\code{columns}}{A three columns \code{\link{data.frame}} giving the vertices
coordinates of the variables convex hull and a identifier to link each row
to a variable.}

\item{\code{lengths}}{A two columns \code{\link{data.frame}} giving the convex hull
maximum dimension length of each sample and a identifier to link each row to
a sample.}

\item{\code{cutoff}}{A length-one \code{\link{numeric}} vector giving the cutoff
value for sample selection.}

\item{\code{keep}}{A named \code{\link{numeric}} vector giving the subscript of
the samples to be kept.}
}}

\author{
N. Frerebeau
}
