% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{string_unfold}
\alias{string_unfold}
\alias{string_fold}
\title{Fold and unfold strings}
\usage{
string_unfold(x)

string_fold(x, n = 3)
}
\arguments{
\item{x}{character string, should be valid notes or note info such as beats.}

\item{n}{integer, minimum number of consecutive repeated values to warrant
folding, defaults to 3.}
}
\value{
character
}
\description{
Fold or unfold a string on the expansion operator.
}
\details{
These function work on arbitrary stings. They do not perform a noteworthy
check. This allows them to work for \code{info} strings as well. Make sure
your strings are properly formatted. \code{string_fold} always collapses the
output string as space-delimited.
}
\examples{
time <- "8*3 16 4.. 16 16 2 2 4. 8 4 4 8*4 1"
x <- string_unfold(time)
x
string_fold(x) == time

notes <- "a, b, c d e f g# a r ac'e' a c' e' c' r r r a"
x <- string_fold(notes)
x
string_unfold(x) == notes
}
