% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/summary.TableOne.R
\name{summary.TableOne}
\alias{summary.TableOne}
\title{Shows all results in a \code{TableOne} class object}
\usage{
\method{summary}{TableOne}(object, digits = 1, ...)
}
\arguments{
\item{object}{An object that has the \code{CatTable} class to be shown.}

\item{digits}{Number of digits to print.}

\item{...}{For compatibility with generic. Ignored.}
}
\value{
It will print the results.
}
\description{
This method shows all the data a CatTable class object has. This includes
the (optionally stratified) part with summary statistics and p-values from
the approximation method test (chisq.test by default) and exact method test
(fisher.test by default).
}
\examples{
## Load
library(tableone)

## Load Mayo Clinic Primary Biliary Cirrhosis Data
library(survival)
data(pbc)
## Check variables
head(pbc)

## Make categorical variables factors
varsToFactor <- c("status","trt","ascites","hepato","spiders","edema","stage")
pbc[varsToFactor] <- lapply(pbc[varsToFactor], factor)

## Create Table 1 stratified by sex and trt
tableOne <- CreateTableOne(vars = c("time","status","age","ascites","hepato",
                                    "spiders","edema","bili","chol","albumin",
                                    "copper","alk.phos","ast","trig","platelet",
                                    "protime","stage"),
                           strata = c("sex","trt"), data = pbc)

## Just typing the object name will invoke the print.TableOne method
tableOne

## Use the summary.TableOne method for detailed summary
summary(tableOne)
}
\author{
Kazuki Yoshida
}
\seealso{
\code{\link{CreateTableOne}}, \code{\link{print.TableOne}}, \code{\link{summary.TableOne}},
\code{\link{CreateContTable}}, \code{\link{print.ContTable}}, \code{\link{summary.ContTable}},
\code{\link{CreateCatTable}}, \code{\link{print.CatTable}}, \code{\link{summary.CatTable}}
}

