% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1.R
\name{signif_pad}
\alias{signif_pad}
\title{Round numbers to specified significant digits with 0-padding.}
\usage{
signif_pad(x, digits = 3, round.integers = TRUE, round5up = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{digits}{An integer specifying the number of significant digits to keep.}

\item{round.integers}{Should rounding be limited to digits to the right of
the decimal point?}

\item{round5up}{Should numbers with 5 as the last digit always be rounded
up? The standard R approach is "go to the even digit" (IEC 60559 standard,
see \code{\link{round}}), while some other softwares (e.g. SAS, Excel)
always round up.}
}
\value{
A character vector containing the rounded numbers.
}
\description{
A utility function to round numbers to a specified number of
significant digits.  Zeros are kept if they are significant.
}
\examples{
x <- c(0.9001, 12345, 1.2, 1., 0.1)
signif_pad(x, digits=3)
signif_pad(x, digits=3, round.integers=TRUE)

# Compare:
as.character(signif(x, digits=3))
format(x, digits=3, nsmall=3)
prettyNum(x, digits=3, drop0trailing=TRUE)
prettyNum(x, digits=3, drop0trailing=FALSE)

# This is very close.
formatC(x, format="fg", flag="#", digits=3) 
formatC(signif(x, 3), format="fg", flag="#", digits=3)

# Could always remove the trailing "."
sub("[.]$", "", formatC(x, format="fg", flag="#", digits=3))

}
\seealso{
\code{\link{signif}}
\code{\link{formatC}}
\code{\link{prettyNum}}
\code{\link{format}}
}
\keyword{utilities}
