% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-key_by.R
\name{key_by}
\alias{key_by}
\alias{key_by.ExprBuilder}
\title{Set key of the result}
\usage{
key_by(.data, ...)

\method{key_by}{ExprBuilder}(.data, ...,
  .parse = getOption("table.express.parse", FALSE))
}
\arguments{
\item{.data}{Object to be grouped and subsequently keyed.}

\item{...}{Arguments for the specific methods.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}
}
\description{
Group by and set key of the result.
}
\details{
Everything in \code{...} will be wrapped in a call to \code{list}. Its contents work like Clauses for
grouping on columns. The \code{keyby} inside the \link[data.table:data.table]{data.table::data.table} frame.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    key_by(cyl, gear)

}
