% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.shows.trending.R
\name{trakt.shows.trending}
\alias{trakt.shows.trending}
\title{Get trending shows}
\usage{
trakt.shows.trending(limit = 10, extended = "min")
}
\arguments{
\item{limit}{Number of shows to return. Is coerced to \code{integer} and must be greater than 0.}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"full"}, can either be \code{"min"} or \code{"full"}}
}
\value{
A \code{data.frame} containing trending shows with their name and ids
}
\description{
\code{trakt.shows.trending} returns a list of trending shows on trakt.tv.
According to the API docs, it returns all shows being watched right now, where
shows with the most users are returned first.
}
\note{
See \href{http://docs.trakt.apiary.io/#reference/shows/get-trending-shows}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
trakt.shows.trending(5)
}
}
\seealso{
Other show: \code{\link{trakt.getEpisodeData}};
  \code{\link{trakt.getFullShowData}};
  \code{\link{trakt.getSeasons}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.related}};
  \code{\link{trakt.show.season}};
  \code{\link{trakt.show.stats}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.shows.popular}}
}

