% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev_strings.R
\name{string_widths_dev}
\alias{string_widths_dev}
\title{Get string widths as measured by the current device}
\usage{
string_widths_dev(
  strings,
  family = "",
  face = 1,
  size = 12,
  cex = 1,
  unit = "cm"
)
}
\arguments{
\item{strings}{A character vector of strings to measure}

\item{family}{The font families to use. Will get recycled}

\item{face}{The font faces to use. Will get recycled}

\item{size}{The font size to use. Will get recycled}

\item{cex}{The cex multiplier to use. Will get recycled}

\item{unit}{The unit to return the width in. Either \code{"cm"}, \code{"inches"},
\code{"device"}, or \code{"relative"}}
}
\value{
A numeric vector with the width of each of the strings given in
\code{strings} in the unit given in \code{unit}
}
\description{
For certain composition tasks it is beneficial to get the width of a string
as interpreted by the device that is going to plot it. grid provides this
through construction of a \code{textGrob} and then converting the corresponding
grob width to e.g. cm, but this comes with a huge overhead.
\code{string_widths_dev()} provides direct, vectorised, access to the graphic
device for as high performance as possible.
}
\examples{
# Get the widths as measured in cm (default)
string_widths_dev(c('a string', 'an even longer string'))

}
\seealso{
Other device metrics: 
\code{\link{string_metrics_dev}()}
}
\concept{device metrics}
