#  validreactId_Exch.R
#  FBA and friends with R.
#
#  Copyright (C) 2010-2013 Gabriel Gelius-Dietrich, Dpt. for Bioinformatics,
#  Institute for Informatics, Heinrich-Heine-University, Duesseldorf, Germany.
#  All right reserved.
#  Email: geliudie@uni-duesseldorf.de
#
#  This file is part of sybil.
#
#  Sybil is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  Sybil is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with sybil.  If not, see <http://www.gnu.org/licenses/>.


################################################
# Function: .validreactId_Exch
#
#
#


.validreactId_Exch <- function(object) {

  if (!is(object, "reactId_Exch")) {
      return("needs an object of class reactId_Exch!")
  }

  if (length(met_pos(object)) != length(object)) {
      return(paste("slot met_pos must be of length", length(object)))
  }

  if (length(met_id(object)) != length(object)) {
      return(paste("slot met_id must be of length", length(object)))
  }

  if (length(object@uptake) != length(object)) {
      return(paste("slot uptake must be of length", length(object)))
  }

  return(TRUE)
}

