% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCheckout.R
\name{makePkgCheckout}
\alias{makePkgCheckout}
\title{Create a checkout of a package and all it's dependencies from a manifest}
\usage{
makePkgCheckout(
  pkgs,
  pkg_manifest,
  dir,
  get_suggests = c("none", "first", "all"),
  param = SwitchrParam(),
  scm_auths = list(bioconductor = c("readonly", "readonly")),
  repos = defaultRepos()
)
}
\arguments{
\item{pkgs}{character - The packages you will be working on}

\item{pkg_manifest}{Pkgmanifest|SessionManifest - The manifest containing the pkgs and dependencies to checkout}

\item{dir}{character - The directory in which to place the checkouts of packages}

\item{get_suggests}{character - Should 'Suggests' dependencies be retrieved? Options are "none" (never), "first" (for packages in \code{pkgs} but not for dependencies, or "all" (always).}

\item{param}{SwitchrParam - The SwitchrParam to use during the checkout process,}

\item{scm_auths}{list -  A named list of user-password pairs to use during the checkout process}

\item{repos}{character - The package repositories to retrieve dependnecy information from for pkgs/dependnecies which do not appear in \code{pkg_manifest}}
}
\value{
a character vector of all packages (incl. recursive dependnecies) checked out into \code{dir}
}
\description{
Create a checkout of a package and all it's dependencies from a manifest
}
