% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_results.R
\name{get_swissvotes}
\alias{get_swissvotes}
\title{Get national results and counting status for selected dates or a given period}
\usage{
get_swissvotes(geolevel = "municipality", votedates = NULL,
  from_date = NULL, to_date = NULL)
}
\arguments{
\item{geolevel}{geographical level for which the results should be loaded. options:  options: "national", "canton", "district" or "municipality"}

\item{votedates}{dates of the ballots to be selected. Default: most recent ballot available. Format = "YYYY-MM-DD"}

\item{from_date}{starting point in time from which vote-results should be retrived. Format = "YYYY-MM-DD"}

\item{to_date}{end point in time to which vote-results should be retrived. Format = "YYYY-MM-DD"}
}
\value{
a tibble containing the results
}
\description{
\code{get_swissvotes} is one of the two main functions of swissvote package. It allows to retrieve the results and the counting status for national ballots.
}
\details{
get_swissvotes - retrieve vote results for national ballots at district- or municipality level for selected dates or a given date range.
}
\examples{
 \donttest{

# Selection by enddate only
 get_swissvotes(to_date="1983-12-04")
 

 # Selection of a specific votedate
 get_swissvotes(votedates="2014-02-09")

glimpse(results)


}

}
