% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{svycdiff}
\alias{svycdiff}
\title{Controlled Difference Estimation for Complex Surveys}
\usage{
svycdiff(
  df,
  id_form,
  a_form,
  s_form,
  y_form,
  y_fam = NULL,
  strata = NULL,
  cluster = NULL
)
}
\arguments{
\item{df}{a data frame or tibble containing the variables in the models.}

\item{id_form}{a string indicating which identification formula to be used.
Options include "OM", "IPW1", or "IPW2". See 'Details' for more information.}

\item{a_form}{an object of class `formula` which describes the propensity
score model to be fit.}

\item{s_form}{an object of class `formula` which describes the selection
model to be fit.}

\item{y_form}{an object of class `formula` which describes the outcome model
to be fit. Only used if `id_form` = "OM", else `y_form = y ~ 1`.}

\item{y_fam}{a family function. Only used if `id_form` = "OM", else
`y_fam = NULL`.}

\item{strata}{a string indicating strata, else `strata = NULL` for no strata.}

\item{cluster}{a string indicating cluster IDs, else `cluster = NULL` for no
clusters.}
}
\value{
`svycdiff` returns an object of class "svycdiff" which contains:

\describe{
   \item{id_form}{A string denoting Which method was selected for estimation}
   \item{cdiff}{A named vector containing the point estimate (est),
                standard error (err), lower confidence limit (lcl),
                upper confidence limit (ucl), and p-value (pval) for
                the estimated controlled difference}
   \item{fit_y}{An object of class inheriting from "glm" corresponding to
                the outcome model fit, or NULL for IPW1 and IPW2}
   \item{fit_a}{An object of class inheriting from "glm" corresponding to
                the propensity model fit}
   \item{wtd_fit_a}{An object of class inheriting from "glm" corresponding
                    to the weighted propensity model fit}
   \item{fit_s}{An object of class "betareg" corresponding to the selection
                model fit, or NULL if the selection mechanism is known}
}
}
\description{
This is the main function to estimate population average controlled
difference (ACD), or under stronger assumptions, the population average
treatment effect (PATE), for a given outcome between levels of a binary
treatment, exposure, or other group membership variable of interest for
clustered, stratified survey samples where sample selection depends on
the comparison group.
}
\details{
The argument \code{id_form} takes possible values "OM", "IPW1", or "IPW2",
corresponding to the three formulas presented in Salerno et al. "OM" refers
to the method that uses outcome modeling and direct standardization to
estimate the controlled difference, while IPW1 and IPW2 are inverse
probability weighted methods. IPW1 and IPW2 differ with respect to how the
joint propensity and selection mechanisms are factored (see Salerno et al.
for additional details). "OM", "IPW1", or "IPW2" are useful in different
settings, which warrants some brief discussion here. "OM" requires you to
specify an outcome regression model, whereas "IPW1" and "IPW2" do not
require estimation, nor do they assume additivity or interactivity. However,
while OM, IPW1, and IPW2 are consistent, OM is most efficient if correctly
specified.

For IPW1/IPW2, \code{y_form} should be of the form \code{Y ~ 1}.

For known S, \code{s_form} should be of the form \code{S ~ 1}, where
\code{S} is the variable corresponding to the probability of selection.
There should be two additional variables in the dataset: P_S_cond_A1X and
P_S_cond_A0X, corresponding to the known probability of selection
conditional on A = 1 or 0 and X = x, respectively. If these quantities are
not known, s_form should contain the variables which affect sample selection
on the right hand side of the equation, including the comparison group
variable of interest.
}
\examples{

N <- 1000

dat <- simdat(N)

S <- rbinom(N, 1, dat$P_S_cond_AX)

samp <- dat[S == 1,]

y_mod <- Y ~ A * X

a_mod <- A ~ X

s_mod <- P_S_cond_AX ~ A + X

fit <- svycdiff(samp, "OM", a_mod, s_mod, y_mod, "gaussian")

fit

summary(fit)

}
