% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_form.R
\name{dlg_form}
\alias{dlg_form}
\alias{dlgForm}
\alias{dlgForm.gui}
\alias{dlgForm.textCLI}
\alias{dlgForm.nativeGUI}
\title{Modal dialog to fill a series of different fields.}
\usage{
dlg_form(form, title = "Fill the form", message = NULL, columns = 1,
  strip.type = TRUE, ..., gui = .GUI)

dlgForm(form, title = "Fill the form", message = NULL, columns = 1,
  strip.type = TRUE, ..., gui = .GUI)

\method{dlgForm}{gui}(form, title = "Fill the form", message = NULL,
  columns = 1, strip.type = TRUE, ..., gui = .GUI)

\method{dlgForm}{textCLI}(form, title = "Fill the form", message = NULL,
  columns = 1, strip.type = TRUE, ..., gui = .GUI)

\method{dlgForm}{nativeGUI}(form, title = "Fill the form", message = NULL,
  columns = 1, strip.type = TRUE, ..., gui = .GUI)
}
\arguments{
\item{form}{Named list of default values, or list of possible items. Names
are the labels of corresponding entries in the dialog box, followed by an
indicator of the type of entry to place in the dialog box (see details).}

\item{title}{The title of the form.}

\item{message}{An optional message to display in the dialog box. Use
\code{\\n} for line break, or provide a vector of character strings, one for
each line.}

\item{columns}{Arrange the entries on this number of columns (by row).}

\item{strip.type}{Do we strip the type from the names in results?}

\item{...}{Pass further arguments to methods.}

\item{gui}{The 'gui' object concerned by this dialog box.}
}
\value{
The modified 'gui' object is returned invisibly. Use its \code{gui$res}
component to get the list of returned fields.
}
\description{
A customizable form dialog box with checkboxes, entries, lists, etc.
}
\details{
The form content is defined by a named list. Items are default
values, or a list of possible items, e.g., for the combobox. Names are labels
displayed in front of each field in the form. Follow them by a code that
represents the type of entry you want to use:
\itemize{
\item \code{:TXT} for simple (default) textual box,
\item \code{:H} for hidden text (password),
\item \code{:RO} for read-only text,
\item \code{:NUM} for null of positive integers with up/down arrows,
\item \code{:CHK} for checkbox: \code{TRUE} or \code{FALSE},
\item \code{:CB} for read-only combobox,
\item \code{:CBE} for editable combobox,
\item \code{:FL} to select one existing file,
\item \code{:MFL} to select multiple existing files,
\item \code{:SFL} to select or create one file,
\item \code{:DIR} to select a directory,
\item \code{:CDIR} to select or create a directory,
\item \code{:FN} to select font and font size,
\item \code{:DT} to enter a date,
\item :CLR` to enter a RGB color,
\item :BTN` to create a button that execute some code,
\item \code{:LBL} to add a label.
}

For the moment, the form dialog box is only supported on Linux. You have to
install \strong{yad} to get access to it. On Ubuntu, you do so by
\code{sudo apt-get install yad}. For other system, look at the documentation.
}
\note{
\code{dlg_form()} can use strings with embedded quotes, but you have to
escape them (and need to double the backslash escape sign). Currently,
this is not done automatically, on the contrary to the other \code{dlg_xxx()}
functions!
}
\examples{
\dontrun{
# Ask a series of items at once in a dialog box
form <- list(
  "Name:TXT" = "John Smith",
  "Age:NUM" = 25,
  "Sex:CB" = c("male", "female"),
  "Married:CHK" = FALSE
)
dlg_form(form, "My data")$res
}
}
\seealso{
\code{\link[=dlg_input]{dlg_input()}}, \code{\link[=dlg_list]{dlg_list()}}
}
\concept{
Modal dialog box
}
\keyword{misc}
