% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggflexsurvplot.R
\name{ggflexsurvplot}
\alias{ggflexsurvplot}
\title{Ggplots of Fitted Flexible Survival Models}
\usage{
ggflexsurvplot(fit, data = NULL, fun = c("survival", "cumhaz"),
  summary.flexsurv = NULL, size = 1, conf.int = FALSE,
  conf.int.flex = conf.int, conf.int.km = FALSE, legend.labs = NULL, ...)
}
\arguments{
\item{fit}{an object of class \code{flexsurvreg}.}

\item{data}{the data used to fit survival curves.}

\item{fun}{the type of survival curves. Allowed values include "survival"
(default) and "cumhaz" (for cumulative hazard).}

\item{summary.flexsurv}{(optional) the summary of the \code{flexsurvreg}
object as generated by the function \code{summary()}.}

\item{size}{line size for the flexible survival estimates.}

\item{conf.int, conf.int.flex}{logical. If TRUE, add confidence bands for
flexible survival estimates.}

\item{conf.int.km}{same as \code{conf.in.flex} but for the kaplan-meier
estimates.}

\item{legend.labs}{character vector specifying legend labels. Used to replace
the names of the strata from the fit. Should be given in the same order as
those strata.}

\item{...}{additional arguments passed to the function \code{\link{ggsurvplot}()}.}
}
\value{
a ggsurvplot
}
\description{
Create ggplot2-based graphs for flexible survival models.
}
\examples{
if(!require("flexsurv")) install.packages("flexsurv")
require("flexsurv")
fit <- flexsurvreg(Surv(rectime, censrec) ~ group,
                   dist = "gengamma", data = bc)
ggflexsurvplot(fit)

}
\author{
Alboukadel Kassambara, \email{alboukadel.kassambara@gmail.com}
}
