% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{castaway_details}
\alias{castaway_details}
\title{Castaway details}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{castaway_id}}{ID of the castaway (primary key). Consistent across seasons and name changes e.g. Amber Brkich / Amber Mariano. The first two letters reference the country of the version played e.g. US, AU (TBA).}
  \item{\code{full_name}}{Full name of the castaway}
  \item{\code{full_name_detailed}}{A detailed version of full_name for plotting e.g. 'Boston' Rob Mariano}
  \item{\code{castaway}}{Short name of the castaway. Name typically used during the season. Sometimes there are multiple
  people with the same name e.g. Rob C and Rob M in Survivor All-Stars. This field takes the most verbose name used}
  \item{\code{date_of_birth}}{Date of birth}
  \item{\code{date_of_death}}{Date of death}
  \item{\code{gender}}{Gender of castaway}
  \item{\code{race}}{Race (if known)}
  \item{\code{ethnicity}}{Ethnicity (if known)}
  \item{\code{poc}}{POC indicator if known and can point to a source, else marked as white. It is understood this is a contentious issue and ultimately up to the individual as to how they wish to be identified. Please log corrections on the Github page.}
  \item{\code{personality_type}}{The Myer-Briggs personality type of the castaway}
  \item{\code{lgbt}}{LGBTQIA+ status as listed on the survivor wiki.}
  \item{\code{occupation}}{Occupation}
  \item{\code{three_words}}{Answer to the question "three words to describe you?"}
  \item{\code{hobbies}}{Answer to the question "what are you favourite hobbies?"}
  \item{\code{pet_peeves}}{Answer to the question "what are your pet peeves?"}
}
}
\source{
\url{https://survivor.fandom.com/wiki/Main_Page},
\url{https://www.personality-database.com/}
}
\usage{
castaway_details
}
\description{
A dataset containing details on the castaways for each season
}
\details{
Race and ethnicity data is included if known and can point to a source, rather than making an assumption
about an individual.
}
\examples{
library(dplyr)
castaway_details |>
  count(gender)
}
\keyword{datasets}
