\name{testSim}
\alias{testSim}
\encoding{latin1}
\title{Print xtable for a Simulated Disease and the Summary}
\description{Just a test method.
}
\usage{
    testSim(p = 0.99, r = 0.01, length = 400, A = 1, alpha = 1,
            beta = 0, phi = 0, frequency = 1, state = NULL, K, 
            range = 200:400)
}
\arguments{
\item{p}{probability to get a new epidemy at time i if there was one at time i-1, default 0.99}
\item{r}{probability to get no new epidemy at time i if there was none at time i-1, default 0.01}
\item{length}{number of weeks to model, default 400}
\item{A}{amplitude (range of sinus), default = 1}
\item{alpha}{parameter to move along the y-axis (negative values not allowed)
    with alpha > = A, default = 1}
\item{beta}{regression coefficient, default = 0}
\item{phi}{factor to create seasonal moves
    (moves the curve along the x-axis), default = 0}
\item{frequency}{factor to determine the oscillation-frequency, default = 1}
\item{state}{use a state chain to define the status at this timepoint (outbreak or not).
    If not given a Markov chain is generated by the programme, default NULL}
\item{K}{additional weigth for an outbreak which influences the distribution
    parameter mu, default = 0}
\item{range}{range of timepoints to be evaluated by the RKI 1 system, default 200:400.}
}
\value{
\item{xtable}{one printed latex table and a result plot}
}
\details{A pointSource epidemy is generated and sent to the RKI 1 system, the quality values for
  the result are computed and shown as a latex table. Additionally a plot of the result
  is generated.
}
\seealso{\code{\link{sim.pointSource}}, \code{\link{algo.call}}, \code{\link{algo.compare}},
  \code{\link{plot.survRes}}, \code{\link{compMatrix.writeTable}}
}
\author{M. Hhle, A. Riebler, C. Lang}
\examples{
    testSim(K = 2)
    testSim(r = 0.5, K = 5)
}

%\keyword{}


