% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazardcross._Weibull.R
\docType{data}
\name{hazardcross_Weibull}
\alias{hazardcross_Weibull}
\title{Simulated survival data with crossing hazard functions from the Weibull distribution}
\format{The \code{hazardcross_Weibull} is a data frame with 100 observations of 3 variables,
and has the following columns:
\itemize{
   \item \code{time} the observed times to first remission and censoring times
   \item \code{censor} the censoring indicator
   \item \code{group} the grouping variable
}}
\usage{
hazardcross_Weibull
}
\description{
The data frame \code{hazardcross_Weibull} is obtained as follows. The survival time 
is generated from the Weibull model displayed as the solid and dashed lines
in the right panel of Figure 1 in Chang and McKeague (2019). The censoring distributions
 (the same in each arm) is specified to be uniform with administrative censoring at \eqn{t = 10}, 
 and a censoring rate of \eqn{25\%} in the first group.
}
\references{
H. Chang, I.W. McKeague, "Nonparametric testing for multiple survival functions with non-inferiority margins,"
 \emph{Annals of Statistics}, Vol. 47, No. 1, pp. 205-232, (2019).
}
\seealso{
\code{\link{nocrossings}}, \code{\link{ptwiseELtest}}, \code{\link{supELtest}}
}
\keyword{datasets}
