% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcoa_ord.R
\name{pcoa_ord}
\alias{pcoa_ord}
\title{Publication-Quality Principal Coordinates Analysis (PCoA) Ordinations}
\usage{
pcoa_ord(
  mod = NULL,
  groupcol = NULL,
  title = NA,
  colors = c("#41b6c4", "#c51b7d", "#7fbc41", "#d73027", "#4575b4", "#e08214", "#8073ac",
    "#f1b6da", "#b8e186", "#8c96c6"),
  shapes = rep(x = 21:25, times = 2),
  lines = rep(x = 1, times = 10),
  leg_pos = "bottomleft",
  leg_cont = unique(groupcol)
)
}
\arguments{
\item{mod}{Object returned by \code{ape::pcoa}}

\item{groupcol}{(dataframe) column specification in the data that includes the groups (accepts either bracket or $ notation)}

\item{title}{(character) string to use as title for plot}

\item{colors}{(character) vector of colors (as hexadecimal codes) of length >= group levels (default \emph{not} colorblind safe because of need for 10 built-in unique colors)}

\item{shapes}{(numeric) vector of shapes (as values accepted by \code{pch}) of length >= group levels}

\item{lines}{(numeric) vector of line types (as integers) of length >= group levels}

\item{leg_pos}{(character or numeric) legend position, either numeric vector of x/y coordinates or shorthand accepted by \code{graphics::legend}}

\item{leg_cont}{(character) vector of desired legend entries. Defaults to \code{unique} entries in \code{groupcol} argument (this argument provided in case syntax of legend contents should differ from data contents)}
}
\value{
(base R plot) base R plot with ellipses for each group
}
\description{
Produces Principal Coordinates Analysis (PCoA) ordinations for up to 10 groups. Assigns a unique color for each group and draws an ellipse around the standard deviation of the points. Automatically adds percent of variation explained by first two principal component axes parenthetically to axis labels. Because there are only five hollow shapes (see \code{?graphics::pch}) all shapes are re-used a maximum of 2 times when more than 5 groups are supplied.
}
\examples{
\donttest{
# Use data from the vegan package
data("varespec", package = 'vegan')
resp <- varespec

# Make some columns of known number of groups
factor_4lvl <- c(rep.int("Trt1", (nrow(resp)/4)),
                 rep.int("Trt2", (nrow(resp)/4)),
                 rep.int("Trt3", (nrow(resp)/4)),
                 rep.int("Trt4", (nrow(resp)/4)))

# And combine them into a single data object
data <- cbind(factor_4lvl, resp)

# Get a distance matrix from the data
dist <- vegan::vegdist(resp, method = 'kulczynski')

# Perform a PCoA on the distance matrix to get points for an ordination
pnts <- ape::pcoa(dist)

# Test the function for 4 groups
pcoa_ord(mod = pnts, groupcol = data$factor_4lvl)
}
}
