% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KNNTrainer.R
\name{KNNTrainer}
\alias{KNNTrainer}
\title{K Nearest Neighbours Trainer}
\format{\code{\link{R6Class}} object.}
\description{
Trains a k nearest neighbour model using fast search algorithms. KNN is a supervised learning
             algorithm which is used for both regression and classification problems.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
bst = KNNTrainer$new(k=1, prob=FALSE, algorithm=NULL, type="class")
bst$fit(X_train, X_test, "target")
bst$predict(type)
}
}

\section{Methods}{

\describe{
    \item{\code{$new()}}{Initialise the instance of the trainer}
    \item{\code{$fit()}}{trains the knn model and stores the test prediction}
    \item{\code{$predict()}}{returns predictions}
}
}

\section{Arguments}{

\describe{
    \item{k}{number of neighbours to predict}
    \item{prob}{if probability should be computed, default=FALSE}
    \item{algorithm}{algorithm used to train the model, possible values are 'kd_tree','cover_tree','brute'}
    \item{type}{type of problem to solve i.e. regression or classification, possible values are 'reg' or 'class'}
}
}

\examples{
data("iris")

iris$Species <- as.integer(as.factor(iris$Species))

xtrain <- iris[1:100,]
xtest <- iris[101:150,]

bst <- KNNTrainer$new(k=3, prob=TRUE, type="class")
bst$fit(xtrain, xtest, 'Species')
pred <- bst$predict(type="raw")

## ------------------------------------------------
## Method `KNNTrainer$new`
## ------------------------------------------------

data("iris")

iris$Species <- as.integer(as.factor(iris$Species))

xtrain <- iris[1:100,]
xtest <- iris[101:150,]

bst <- KNNTrainer$new(k=3, prob=TRUE, type="class")
bst$fit(xtrain, xtest, 'Species')
pred <- bst$predict(type="raw")

## ------------------------------------------------
## Method `KNNTrainer$fit`
## ------------------------------------------------

data("iris")

iris$Species <- as.integer(as.factor(iris$Species))

xtrain <- iris[1:100,]
xtest <- iris[101:150,]

bst <- KNNTrainer$new(k=3, prob=TRUE, type="class")
bst$fit(xtrain, xtest, 'Species')

## ------------------------------------------------
## Method `KNNTrainer$predict`
## ------------------------------------------------

data("iris")

iris$Species <- as.integer(as.factor(iris$Species))

xtrain <- iris[1:100,]
xtest <- iris[101:150,]

bst <- KNNTrainer$new(k=3, prob=TRUE, type="class")
bst$fit(xtrain, xtest, 'Species')
pred <- bst$predict(type="raw")
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{k}}{number of neighbours to predict}

\item{\code{prob}}{if probability should be computed, default=FALSE}

\item{\code{algorithm}}{algorithm used to train the model, possible values are 'kd_tree','cover_tree','brute'}

\item{\code{type}}{type of problem to solve i.e. regression or classification, possible values are 'reg' or 'class'}

\item{\code{model}}{for internal use}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{KNNTrainer$new()}}
\item \href{#method-fit}{\code{KNNTrainer$fit()}}
\item \href{#method-predict}{\code{KNNTrainer$predict()}}
\item \href{#method-clone}{\code{KNNTrainer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNNTrainer$new(k, prob, algorithm, type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k}}{k number of neighbours to predict}

\item{\code{prob}}{if probability should be computed, default=FALSE}

\item{\code{algorithm}}{algorithm used to train the model, possible values are 'kd_tree','cover_tree','brute'}

\item{\code{type}}{type of problem to solve i.e. regression or classification, possible values are 'reg' or 'class'}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a new `KNNTrainer` object.
}

\subsection{Returns}{
A `KNNTrainer` object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data("iris")

iris$Species <- as.integer(as.factor(iris$Species))

xtrain <- iris[1:100,]
xtest <- iris[101:150,]

bst <- KNNTrainer$new(k=3, prob=TRUE, type="class")
bst$fit(xtrain, xtest, 'Species')
pred <- bst$predict(type="raw")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\subsection{Method \code{fit()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNNTrainer$fit(train, test, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{train}}{data.frame or matrix}

\item{\code{test}}{data.frame or matrix}

\item{\code{y}}{character, name of target variable}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Trains the KNNTrainer model
}

\subsection{Returns}{
NULL
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data("iris")

iris$Species <- as.integer(as.factor(iris$Species))

xtrain <- iris[1:100,]
xtest <- iris[101:150,]

bst <- KNNTrainer$new(k=3, prob=TRUE, type="class")
bst$fit(xtrain, xtest, 'Species')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\subsection{Method \code{predict()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNNTrainer$predict(type = "raw")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character, 'raw' for labels else 'prob'}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Predits the nearest neigbours for test data
}

\subsection{Returns}{
a list of predicted neighbours
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data("iris")

iris$Species <- as.integer(as.factor(iris$Species))

xtrain <- iris[1:100,]
xtest <- iris[101:150,]

bst <- KNNTrainer$new(k=3, prob=TRUE, type="class")
bst$fit(xtrain, xtest, 'Species')
pred <- bst$predict(type="raw")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNNTrainer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
