% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenbar.R
\name{eigenbar}
\alias{eigenbar}
\title{The eigenvalue of the OMI analysis}
\usage{
eigenbar(
  subnic,
  col.sel = "black",
  col.unsel = "grey",
  ylab = "Eigen values in \%",
  names.arg = NULL,
  main = NA,
  ...
)
}
\arguments{
\item{subnic}{an object of class \code{subniche}.}

\item{col.sel}{the color of the selected axes}

\item{col.unsel}{the color of the other axes}

\item{ylab}{label for y-axis, see \link[graphics]{title} for more details.}

\item{names.arg}{a vector of names to be plotted below each bar or group of bars. If this argument is omitted, then the names are taken from the names attribute of height if this is a vector, or the column names if it is a matrix.}

\item{main}{a main title for the plot, see \link[graphics]{title} for more details.}

\item{...}{further arguments passed to or from other methods see \link[graphics]{barplot}}
}
\description{
The function plot the eigenvalues of the OMI analysis
}
\details{
The black bars represents the selected axes for the OMI analysis
See \doi{10.7717/peerj.3364} for more details on the subniche concept.
}
\examples{
library(subniche)
data(doubs)
dudi1 <- dudi.pca(doubs$env, scale = TRUE, scan = FALSE, nf = 3)
nic1 <- niche(dudi1, doubs$fish, scann = FALSE)
# number of sites
N <- dim(nic1$ls)[1]
#Create a factor which defines the subsets
fact <- factor(c(rep(1,N/2),rep(2,N/2)))
# nic1 will be use as reference and fact will be use to define the subniches environment
subnic1 <- subniche(nic1, fact)
eigenbar(subnic1)
}
