% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environments.R
\name{parser_version_set}
\alias{parser_version_set}
\alias{parser_version_get}
\alias{parser_version_find}
\title{Work with parser versions}
\usage{
parser_version_set(version)

parser_version_get()

parser_version_find(pd)
}
\arguments{
\item{version}{The version of the parser to be used.}

\item{pd}{A parse table such as the output from
\code{utils::getParseData(parse(text = text))}.}
}
\description{
The structure of the parse data affects many operations in styler. There was
unexpected behavior of the parser that styler was initially designed to work
around. Examples are \href{https://github.com/r-lib/styler/issues/187}{#187},
\href{https://github.com/r-lib/styler/issues/216}{#216},
\href{https://github.com/r-lib/styler/issues/100}{#100} and others. With
\href{https://github.com/r-lib/styler/issues/419}{#419}, the structure of the parse
data changes and we need to dispatch for older versions. As it is inconvenient
to pass a parser version down in the call stack in various places, the
environment \code{env_current} is used to store the current version \emph{globally}
but internally.
}
\details{
We version the parser as follows:
\itemize{
\item version 1: Before fix mentioned in #419.
\item version 2: After #419.
}

The following utilities are available:
\itemize{
\item \code{parser_version_set()} sets the parser version in the environment
\code{env_current}.
\item \code{parser_version_get()} retrieves the parser version from the
environment \code{env_current}.
\item \code{parser_version_find()} determines the version of the parser from parse
data. This does not necessarily mean that the version found is the
actual version, but it \emph{behaves} like it. For example, code that does not
contain \code{EQ_ASSIGN} is parsed the same way with version 1 and 2. If the
behavior is identical, the version is set to 1.
}
}
\keyword{internal}
