% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{shallowify}
\alias{shallowify}
\title{Shallowify the parse table}
\usage{
shallowify(pd)
}
\description{
Cached expressions don't need to be transformed with \code{transformers} in
\code{\link[=parse_transform_serialize_r_block]{parse_transform_serialize_r_block()}}, we simply return \code{text} for the
top-level token.
}
\details{
Expressions that are cached are already styled correctly. We can make the
parse table shallow at these locations, fully relying on the \code{text} column:
\itemize{
\item remove all children, as they are not needed anymore.
\item mark the expression as a terminal.
}
}
\section{Top-level comments}{

Note that we do not cache top-level comments. Because package code has a lot
of roxygen comments and each of them is a top-level expression, checking is
very expensive. More expensive than styling, because comments are always
terminals. This will also yield large speed improvements in
\code{\link[=compute_parse_data_nested]{compute_parse_data_nested()}} because nesting is expensive and will not be
done for cached expressions.
}

\section{Implementation}{

Because the structure of the parse table is not always "top-level expression
first, then children", this function creates a temporary parse table that has
this property and then extract the ids and subset the original parse table so
it is shallow in the right places.
}

\keyword{internal}
