% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getKit.r
\name{getKit}
\alias{getKit}
\title{Get Kit}
\usage{
getKit(kit = NULL, what = NA, show.messages = FALSE,
  .kit.info = NULL, debug = FALSE)
}
\arguments{
\item{kit}{string or integer to specify the kit.}

\item{what}{string to specify which information to return. Default is 'NA' which return all info.
Not case sensitive.}

\item{show.messages}{logical, default TRUE for printing messages to the R prompt.}

\item{.kit.info}{data frame, run function on a data frame instead of the kits.txt file.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with kit information.
}
\description{
Provides information about STR kits.
}
\details{
The function returns the following information for a kit specified in kits.txt:
Panel name, short kit name (unique, user defined), full kit name (user defined),
marker names, allele names, allele sizes (bp), 
minimum allele size, maximum allele size (bp), flag for virtual alleles,
marker color, marker repeat unit size (bp), minimum marker size, 
maximum marker, marker offset (bp), flag for sex markers (TRUE/FALSE).

If no matching kit or kit index is found NA is returned.
If kit='NULL' or '0' a vector of available kits is printed and NA returned.
}
\examples{
# Show all information stored for kit with short name 'ESX17'.
getKit("ESX17")
}
