% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterProfile.r
\name{filterProfile}
\alias{filterProfile}
\title{Filter Profile}
\usage{
filterProfile(data, ref, add.missing.loci = FALSE, keep.na = FALSE,
  ignore.case = TRUE, exact = FALSE, invert = FALSE, debug = FALSE)
}
\arguments{
\item{data}{data frame with genotype data in 'slim' format.}

\item{ref}{data frame with reference profile in 'slim' format.}

\item{add.missing.loci}{logical. TRUE add loci present in ref but not in data.
Overrides keep.na=FALSE.}

\item{keep.na}{logical. FALSE discards NA alleles.
TRUE keep loci/sample even if no matching allele.}

\item{ignore.case}{logical TRUE ignore case.}

\item{exact}{logical TRUE use exact matching of sample names.}

\item{invert}{logical TRUE filter peaks NOT matching the reference.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with extracted result.
}
\description{
Filter peaks from profiles.
}
\details{
Filters out the peaks matching (or not matching) specified known profiles
from typing data containing 'noise' such as stutters.
If 'ref' does not contain a 'Sample.Name' column it will be used
as reference for all samples in 'data'. The 'invert' option filters out
peaks NOT matching the reference (e.g. drop-in peaks).
NB! add.missing.loci overrides keep.na.
Returns data where allele names match/not match 'ref' allele names.
Required columns are: 'Sample.Name', 'Marker', and 'Allele'.
}

