% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_locate_last}
\alias{stri_locate_last}
\title{Locate Last Occurrence of a Pattern}
\usage{
stri_locate_last(str, ..., regex, fixed, coll, charclass)
}
\arguments{
\item{str}{character vector of strings to search in}

\item{...}{additional arguments passed to the underlying functions}

\item{regex}{character vector; regular expressions}

\item{fixed}{character vector; fixed patterns}

\item{coll}{character vector; canonically equivalent patterns}

\item{charclass}{character vector; identifiers of character classes}
}
\value{
Returns an integer matrix with two columns, with
double \code{NA}s in a row if a pattern has not been found.
}
\description{
A convenience function.
Calls either \code{\link{stri_locate_last_regex}},
\code{\link{stri_locate_last_fixed}},
\code{\link{stri_locate_last_coll}},
or \code{\link{stri_locate_last_charclass}},
depending on the argument used.
}
\details{
Unless you are very lazy, please call the underlying functions
directly for better performance.
}
\examples{
s <- 'Lorem ipsum dolor sit amet, consectetur adipisicing elit.'

\dontshow{if (stri_install_check(silent=TRUE))}
stri_locate_last('XaaaaX',
   regex=c('\\\\p{Ll}', '\\\\p{Ll}+', '\\\\p{Ll}{2,3}', '\\\\p{Ll}{2,3}?'))

\dontshow{if (stri_install_check(silent=TRUE))}
stri_locate_last('Bartolini', fixed=letters[1:3])

\dontshow{if (stri_install_check(silent=TRUE))}
stri_locate_last('a b c', charclass='\\\\p{Zs}')
}
\seealso{
Other indexing: \code{\link{stri_locate_all_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_last_charclass}},
  \code{\link{stri_locate_last_charclass}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_locate_all_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_last_regex}},
  \code{\link{stri_locate_last_regex}};
  \code{\link{stri_locate_all}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_first}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_locate}}; \code{\link{stri_sub}},
  \code{\link{stri_sub<-}}

Other search_locate: \code{\link{stri_locate_all_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_last_charclass}},
  \code{\link{stri_locate_last_charclass}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_locate_all_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_last_regex}},
  \code{\link{stri_locate_last_regex}};
  \code{\link{stri_locate_all}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_first}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_locate}}; \code{\link{stringi-search}}
}

