% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num-before.R
\name{str_nth_number_before_mth}
\alias{str_nth_number_before_mth}
\alias{str_nth_number_before_first}
\alias{str_nth_number_before_last}
\alias{str_first_number_before_mth}
\alias{str_last_number_before_mth}
\alias{str_first_number_before_first}
\alias{str_first_number_before_last}
\alias{str_last_number_before_first}
\alias{str_last_number_before_last}
\title{Find the \code{n}th number before the \code{m}th occurrence of a pattern.}
\usage{
str_nth_number_before_mth(string, pattern, n, m, decimals = FALSE,
  leading_decimals = decimals, negs = FALSE, sci = FALSE,
  commas = FALSE, leave_as_string = FALSE)

str_nth_number_before_first(string, pattern, n, decimals = FALSE,
  leading_decimals = decimals, negs = FALSE, sci = FALSE,
  commas = FALSE, leave_as_string = FALSE)

str_nth_number_before_last(string, pattern, n, decimals = FALSE,
  leading_decimals = decimals, negs = FALSE, sci = FALSE,
  commas = FALSE, leave_as_string = FALSE)

str_first_number_before_mth(string, pattern, m, decimals = FALSE,
  leading_decimals = decimals, negs = FALSE, sci = FALSE,
  commas = FALSE, leave_as_string = FALSE)

str_last_number_before_mth(string, pattern, m, decimals = FALSE,
  leading_decimals = decimals, negs = FALSE, sci = FALSE,
  commas = FALSE, leave_as_string = FALSE)

str_first_number_before_first(string, pattern, decimals = FALSE,
  leading_decimals = decimals, negs = FALSE, sci = FALSE,
  commas = FALSE, leave_as_string = FALSE)

str_first_number_before_last(string, pattern, decimals = FALSE,
  leading_decimals = decimals, negs = FALSE, sci = FALSE,
  commas = FALSE, leave_as_string = FALSE)

str_last_number_before_first(string, pattern, decimals = FALSE,
  leading_decimals = decimals, negs = FALSE, sci = FALSE,
  commas = FALSE, leave_as_string = FALSE)

str_last_number_before_last(string, pattern, decimals = FALSE,
  leading_decimals = decimals, negs = FALSE, sci = FALSE,
  commas = FALSE, leave_as_string = FALSE)
}
\arguments{
\item{string}{A character vector.}

\item{pattern}{The pattern to look for.

The default interpretation is a regular expression, as described in
\link[stringi:stringi-search-regex]{stringi::stringi-search-regex}.

To match a without regular expression (i.e. as a human would), use
\link[stringr:coll]{coll()}. For details see \code{\link[stringr:regex]{stringr::regex()}}.}

\item{n}{Vectors of integerish values. Must be either length 1 or have
length equal to the length of \code{string}. Negative indices count from the
back: while \code{1} and \code{2} correspond to first and second, \code{-1} and \code{-2}
correspond to last and second-last. \code{0} will return \code{NA}.}

\item{m}{Vectors of integerish values. Must be either length 1 or have
length equal to the length of \code{string}. Negative indices count from the
back: while \code{1} and \code{2} correspond to first and second, \code{-1} and \code{-2}
correspond to last and second-last. \code{0} will return \code{NA}.}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{sci}{Make the search aware of scientific notation e.g. 2e3 is the same
as 2000.}

\item{commas}{Allow comma separators in numbers (i.e. interpret 1,100 as a
single number (one thousand one hundred) rather than two numbers (one and
one hundred)).}

\item{leave_as_string}{Do you want to return the number as a string (\code{TRUE})
or as numeric (\code{FALSE}, the default)?}
}
\value{
A numeric or character vector.
}
\description{
Given a string, a pattern and natural numbers \code{n} and \code{m}, find the \code{n}th
number that comes before the \code{m}th occurrence of the pattern.
}
\examples{
string <- c(
  "abc1abc2abc3abc4def5abc6abc7abc8abc9",
  "abc1def2ghi3abc4def5ghi6abc7def8ghi9"
)
str_nth_number_before_mth(string, "def", 1, 1)
str_nth_number_before_mth(string, "abc", 2, 3)
str_nth_number_before_first(string, "def", 2)
str_nth_number_before_last(string, "def", -1)
str_first_number_before_mth(string, "abc", 2)
str_last_number_before_mth(string, "def", 1)
str_first_number_before_first(string, "def")
str_first_number_before_last(string, "def")
str_last_number_before_first(string, "def")
str_last_number_before_last(string, "def")
}
\seealso{
Other numeric extractors: \code{\link{str_extract_numbers}},
  \code{\link{str_nth_number_after_mth}},
  \code{\link{str_nth_number}}
}
\concept{numeric extractors}
