/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.filters;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceImpl;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.Range;
import java.util.ArrayList;
import java.util.Random;
import moa.core.InstanceExample;
import moa.streams.filters.AbstractStreamFilter;

public class RBFFilter
extends AbstractStreamFilter {
    private static final long serialVersionUID = 1L;
    protected InstancesHeader dataset;
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random noise.", 1);
    public IntOption numLatentOption = new IntOption("numLatent", 'h', "Number of latent variables in the projected space.", 1);
    protected Random random;
    protected double[] c;
    protected double[] r;

    @Override
    public String getPurposeString() {
        return "Creates a random projection of the feature space with RBF functions.";
    }

    @Override
    public InstancesHeader getHeader() {
        return this.inputStream.getHeader();
    }

    @Override
    public InstanceExample nextInstance() {
        Instance x = (Instance)this.inputStream.nextInstance().getData();
        if (this.dataset == null) {
            System.out.println("INIT. ");
            this.initialize(x);
        }
        double[] z_ = new double[this.dataset.numAttributes()];
        InstanceImpl z = new InstanceImpl(x.weight(), z_);
        int d = x.numAttributes();
        int h = this.numLatentOption.getValue();
        int j_c = x.classIndex();
        for (int k = 0; k < h; ++k) {
            double sum_k = 0.0;
            for (int j = 0; j < d; ++j) {
                sum_k += x.value(j) - this.c[k];
            }
            double v = sum_k / Math.pow(this.r[k], 2.0);
            z.setValue(k, Math.exp(-sum_k));
        }
        z.setValue(h, x.classValue());
        z.setDataset(this.dataset);
        return new InstanceExample(z);
    }

    @Override
    protected void restartImpl() {
        System.out.println("RESET ");
        this.random = new Random(this.randomSeedOption.getValue());
    }

    private void initialize(Instance instance) {
        int h = this.numLatentOption.getValue();
        this.c = new double[h];
        this.r = new double[h];
        for (int j = 0; j < h; ++j) {
            this.c[j] = this.random.nextGaussian();
            this.r[j] = this.random.nextDouble();
        }
        Instances ds = new Instances();
        ArrayList<Attribute> v = new ArrayList<Attribute>(h);
        ArrayList<Integer> indexValues = new ArrayList<Integer>(h);
        for (int j = 0; j < h; ++j) {
            v.add(new Attribute("z" + String.valueOf(j)));
            indexValues.add(j);
        }
        v.add(instance.dataset().classAttribute());
        indexValues.add(h);
        ds.setAttributes(v, indexValues);
        Range r = new Range("start-end");
        ds.setRangeOutputIndices(r);
        this.dataset = new InstancesHeader(ds);
        this.dataset.setClassIndex(h);
        System.out.println("" + this.dataset);
        System.out.println("classIndex :  " + this.dataset.classIndex());
        System.out.println("numClasses :  " + this.dataset.numClasses());
        System.out.println("numInstances: " + this.dataset.numInstances());
        System.out.println("numAttribute: " + this.dataset.numAttributes());
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

