/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamProgressMonitor
extends FilterInputStream {
    protected int inputByteSize;
    protected int inputBytesRead;

    public InputStreamProgressMonitor(InputStream in) {
        super(in);
        try {
            this.inputByteSize = in.available();
        }
        catch (IOException ioe) {
            this.inputByteSize = 0;
        }
        this.inputBytesRead = 0;
    }

    public int getBytesRead() {
        return this.inputBytesRead;
    }

    public int getBytesRemaining() {
        return this.inputByteSize - this.inputBytesRead;
    }

    public double getProgressFraction() {
        return (double)this.inputBytesRead / (double)this.inputByteSize;
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (c > 0) {
            ++this.inputBytesRead;
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        int numread = this.in.read(b);
        if (numread > 0) {
            this.inputBytesRead += numread;
        }
        return numread;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int numread = this.in.read(b, off, len);
        if (numread > 0) {
            this.inputBytesRead += numread;
        }
        return numread;
    }

    public long skip(long n) throws IOException {
        long numskip = this.in.skip(n);
        if (numskip > 0L) {
            this.inputBytesRead = (int)((long)this.inputBytesRead + numskip);
        }
        return numskip;
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.inputBytesRead = this.inputByteSize - this.in.available();
    }
}

