% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_Kmeans.R
\name{DSC_Kmeans}
\alias{DSC_Kmeans}
\title{Kmeans Macro-clusterer}
\usage{
DSC_Kmeans(
  formula = NULL,
  k,
  weighted = TRUE,
  iter.max = 10,
  nstart = 10,
  algorithm = c("Hartigan-Wong", "Lloyd", "Forgy", "MacQueen"),
  min_weight = NULL,
  description = NULL
)
}
\arguments{
\item{formula}{\code{NULL} to use all features in the stream or a model \link{formula} of the form \code{~ X1 + X2}
to specify the features used for clustering. Only \code{.}, \code{+} and \code{-} are currently
supported in the formula.}

\item{k}{either the number of clusters, say k, or a set of initial
(distinct) cluster centers. If a number, a random set of (distinct) rows in
x is chosen as the initial centers.}

\item{weighted}{use a weighted k-means (algorithm is ignored).}

\item{iter.max}{the maximum number of iterations allowed.}

\item{nstart}{if centers is a number, how many random sets should be chosen?}

\item{algorithm}{character: may be abbreviated.}

\item{min_weight}{micro-clusters with a weight less than this will be
ignored for reclustering.}

\item{description}{optional character string to describe the clustering
method.}
}
\value{
An object of class \code{DSC_Kmeans} (subclass of \link{DSC},
\link{DSC_R}, \link{DSC_Macro})
}
\description{
Macro Clusterer.
Class implements the k-means algorithm for reclustering a set of
micro-clusters.
}
\details{
\code{\link[=update]{update()}} and \code{\link[=recluster]{recluster()}} invisibly return the assignment of the data points
to clusters.

Please refer to function \code{\link[stats:kmeans]{stats::kmeans()}} for more details on
the algorithm.

\strong{Note} that this clustering cannot be updated iteratively and every time it is
used for (re)clustering, the old clustering is deleted.
}
\examples{
# 3 clusters with 5\% noise
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)

# Use a moving window for "micro-clusters and recluster with k-means (macro-clusters)
cl <- DSC_TwoStage(
  micro = DSC_Window(horizon = 100),
  macro = DSC_Kmeans(k = 3)
)

update(cl, stream, 500)
cl

plot(cl, stream)
}
\seealso{
Other DSC_Macro: 
\code{\link{DSC_DBSCAN}()},
\code{\link{DSC_EA}()},
\code{\link{DSC_Hierarchical}()},
\code{\link{DSC_Macro}()},
\code{\link{DSC_Reachability}()},
\code{\link{DSC_SlidingWindow}()}
}
\author{
Michael Hahsler
}
\concept{DSC_Macro}
