/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import moa.core.ObjectRepository;
import moa.options.ClassOption;
import moa.options.FloatOption;
import moa.options.StringOption;
import moa.tasks.EvaluateInterleavedTestThenTrain;
import moa.tasks.EvaluatePrequential;
import moa.tasks.MainTask;
import moa.tasks.Task;
import moa.tasks.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunTasks
extends MainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption taskOption = new ClassOption("task", 't', "Task to do.", Task.class, "EvaluatePrequential -l ActiveClassifier -i 1000000 -d temp.txt");
    public StringOption classifierParameterOption = new StringOption("classifierParameter", 'p', "Classifier parameter to vary.", "b");
    public FloatOption firstValueOption = new FloatOption("firstValue", 'f', "First value", 0.0);
    public FloatOption lastValueOption = new FloatOption("lastValue", 'l', "Last value", 1.0);
    public FloatOption incrementValueOption = new FloatOption("incrementValue", 'i', "Increment value", 0.1);
    protected Task task;

    @Override
    public String getPurposeString() {
        return "Runs several experiments modifying values of parameters.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return this.task.getTaskResultType();
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Object result = null;
        String commandString = this.taskOption.getValueAsCLIString();
        for (double valueParameter = this.firstValueOption.getValue(); valueParameter <= this.lastValueOption.getValue(); valueParameter += this.incrementValueOption.getValue()) {
            String classifier;
            this.task = (Task)this.getPreparedClassOption(this.taskOption);
            if (this.task instanceof EvaluatePrequential) {
                classifier = ((EvaluatePrequential)this.task).learnerOption.getValueAsCLIString();
                ((EvaluatePrequential)this.task).learnerOption.setValueViaCLIString(classifier + " -" + this.classifierParameterOption.getValue() + " " + valueParameter);
            }
            if (this.task instanceof EvaluateInterleavedTestThenTrain) {
                classifier = ((EvaluateInterleavedTestThenTrain)this.task).learnerOption.getValueAsCLIString();
                ((EvaluateInterleavedTestThenTrain)this.task).learnerOption.setValueViaCLIString(classifier + " -" + this.classifierParameterOption.getValue() + " " + valueParameter);
            }
            result = this.task.doTask(monitor, repository);
        }
        return result;
    }
}

