% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maf.R
\name{maf}
\alias{maf}
\title{Minor Allele Frequencies}
\usage{
maf(g, by.strata = FALSE, maf.within = FALSE)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{by.strata}{logical - return results grouped by strata?}

\item{maf.within}{if \code{by.strata = TRUE}, identify minor allele 
within each strata independently? If \code{FALSE} minor allele is 
identified from all individuals.}
}
\value{
A vector or matrix of minor allele frequencies at each locus.
}
\description{
Calculate minor allele frequencies for each locus.
}
\examples{
data(msats.g)

maf(msats.g)

# minor allele identified from all indivudals
maf(msats.g, by.strata = TRUE)

# minor allele identified within each strata
maf(msats.g, by.strata = TRUE, maf.within = TRUE)

}
\seealso{
\link{alleleFreqs}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
