% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iupacCode.R
\name{iupacCode}
\alias{iupacCode}
\title{IUPAC Code}
\usage{
iupacCode(bases, ignore.gaps = FALSE)
}
\arguments{
\item{bases}{character vector containing valid nucleotides or IUPAC codes.}

\item{ignore.gaps}{logical. Ignore gaps at a site when creating consensus. 
If true, then bases with a gap are removed before consensus is calculated. 
If false and a gap is present, then the result is a gap.}
}
\value{
a character representing the correct IUPAC code.
}
\description{
Calculate the correct IUPAC code for a vector of nucleotides.
}
\examples{
iupacCode(c("a", "a", "g"))

iupacCode(c("t", "c", "g"))

}
\seealso{
\code{\link{validIupacCodes}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
