% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fastsimcoal.run.R, R/fastsimcoal.write.R
\name{fastsimcoal.run}
\alias{fastsimcoal}
\alias{fastsimcoal.run}
\alias{fastsimcoal.write}
\title{Run FASTSIMCOAL}
\usage{
fastsimcoal.run(num.pops, Ne, sample.size, sample.time = rep(0, num.pops),
  growth.rate = rep(0, num.pops), mig.mat = NULL, hist.ev = NULL,
  num.chrom = 1, data.type = NULL, locus.params = NULL,
  label = "fastsimcoal", num.sims = 1, inf.site.model = F, quiet = T,
  delete.files = T)

fastsimcoal.write(num.pops, Ne, sample.size, sample.time = rep(0, num.pops),
  growth.rate = rep(0, num.pops), mig.mat = NULL, hist.ev = NULL,
  num.chrom = 1, data.type = NULL, locus.params = NULL,
  label = "fastsimcoal")
}
\arguments{
\item{num.pops}{number of populations.}

\item{Ne}{effective population size.}

\item{sample.size}{number of samples to take.}

\item{sample.time}{time to draw samples.}

\item{growth.rate}{growth rate of populations.}

\item{mig.mat}{migration matrix.}

\item{hist.ev}{historical events.}

\item{num.chrom}{number of chromosomes.}

\item{data.type}{type of data.}

\item{locus.params}{locus parameters.}

\item{label}{character string to label files with.}

\item{num.sims}{number of simulations to run.}

\item{inf.site.model}{logical. Infinite site model?}

\item{quiet}{logical. Run quietly?}

\item{delete.files}{logical. Delete files when done?}
}
\value{
A list of \code{\link{gtypes}} objects for each simulated dataset.
}
\description{
Run FASTSIMCOAL to generate a list of simulated gtypes.
}
\note{
Assumes that the program \code{fastsimcoal} is properly installed and available on the command line.
  On PC's, this requires having it in a folder in
  the PATH environmental variable. On Macs, the executable should be installed in a folder
  like \code{/usr/local/bin}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Excoffier, L. and Foll, M (2011) fastsimcoal: a continuous-time coalescent
  simulator of genomic diversity under arbitrarily complex evolutionary scenarios
  Bioinformatics 27: 1332-1334.  \url{http://cmpg.unibe.ch/software/fastsimcoal2/}
}

