% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sim.gamma.haps}
\alias{sim.gamma.haps}
\title{Simulates Haplotypes}
\usage{
sim.gamma.haps(pop.size, num.haps, shape, scale, return.freq = TRUE,
  plot = TRUE)
}
\arguments{
\item{pop.size}{size of population.}

\item{num.haps}{number of haplotypes to generate.}

\item{shape}{shape parameter of Gamma distribution.}

\item{scale}{scale parameter of Gamma distribution.}

\item{return.freq}{logical. Return frequency table of haplotypes? If \code{FALSE} return vector of haplotypes.}

\item{plot}{logical. Show plot of haplotypic frequency distribution?}
}
\value{
Frequency table of haplotypes.
}
\description{
Simulate a haplotypic frequency distribution based on a specified gamma distribution.
}
\examples{
haps <- sim.gamma.haps(1000, 15, 1, 2.5)
print(haps)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\seealso{
\code{\link{dgamma}}
}

