% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.mod.R
\name{loop.optim}
\alias{loop.optim}
\title{Optimizer step for estimating the Heligman-Pollard Parameters using the Bayesian Melding with IMIS-opt procedure.}
\usage{
loop.optim(prior, nrisk, ndeath, age, d = 10, theta.dim = 9)
}
\arguments{
\item{prior}{A matrix containing the prior.}

\item{nrisk}{A vector containing the number of persons at risk in each age group.}

\item{ndeath}{A vector containing the number of deaths in each age group.}

\item{age}{A vector containing the ages at which each age interval begins.}

\item{d}{Number of optimizer iterations.}

\item{theta.dim}{Number of columns of the prior (This should be 9 if estimating all parameters. Functionality for estimation a limited number of parameters does not exist yet).}
}
\value{
\item{opt.mu.d}{A matrix containing the local optimums resulting from the optimizer step. Each local optimum contains a set of 9 parameter values.}
\item{opt.cov.d}{An array containing the covariance matrix for each of the local optimums.}
\item{d.keep}{The number of local optimums found whose likelihood is greater than the maximum likelihood from the prior.}
\item{theta.new}{The set of parameters from the prior with the greatest weight as calculated with prior.likewts.}
\item{log.like.0}{A vector containing a likelihood for each row of the prior.}
\item{wts.0}{A vector containing an importance weight for each row of the prior.}
}
\description{
Performs the optimizer step in the IMIS procedure for the eight Heligman-Pollard parameters.
}
\note{
Occasionally, this step fails to produce an initial local maximum that exceeds the highest likelihood of the prior and a warning is issued. Usually drawing a new prior or selecting a different algorithm solves this problem.
}
\section{Warning}{

If the likelihood for the initial local maximum does not exceed the highlest likelihood from the prior, a warning will be issued.
}

\references{
Poole, D. and Raftery, A. (2000). Inference for Deterministic Simulation Models: The Bayesian Melding Approach. Journal of the American Statistical Association 95:1244–1255.

Raftery, A and Bao, L. (2009). Estimating and Projecting Trends in HIV/AIDS Generalized Epidemics Using Incremental Mixture Importance Sampling. Technical Report 560, Department of Statistics, University of Washington.

Sharrow, D.J., Clark, S.J., Collinson, M.A., Kahn, K. and Tollman, S.M. (2013). The Age Pattern of Increases in Mortality Affected by HIV: Bayesian Fit of the Heligman-Pollard Model to Data from the Agincourt HDSS Field Site in Rural Northeast South Africa. Demogr. Res. 29, 1039–1096.
}
\seealso{
\link{mod} \link{ll.binom} \link{prior.likewts} \link{HP.mod}
}
\keyword{Heligman-Pollard}
\keyword{bycatch}
\keyword{mortality}
