% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{undimlabel}
\alias{undimlabel}
\title{Undimlabel an Object}
\usage{
undimlabel(x, dims = seq_along(dim(x)))
}
\arguments{
\item{x}{object with dimlabels (usually an array of some kind)}

\item{dims}{integer vector of dimension positions or character vector of dimlabels
specifying the dimensions for which dimlabels should be removed. Defaults to all dimensions.}
}
\value{
\code{x} without any dimlabels for the dimensions specified by \code{dims}.
Consistent with how base R handles removed dimlabels, the removed dimlabels are
converted to NA. If all dimlabels are removed, then the dimlabels are empty (aka NULL).
}
\description{
\code{undimname} removes dimlabels from an object. This function is to allow
for removing dimlabels from only certain dimensions specified by \code{dims}.
}
\examples{
# matrix
m <- array(rep.int(NA, times = 4), dim = c(2,2),
   dimnames = list("lower" = c("a","b"),"UPPER" = c("A","B")))
dimlabels(m)
m2 <- undimlabel(m) # remove dimlabels from both dimensions
dimlabels(m2)
m3 <- undimlabel(m, dims = 1) # remove dimlabels from only the first dimenion
dimlabels(m3)
m4 <- undimlabel(m, dims = "lower")
dimlabels(m4)
all.equal(m3, m4) # same return object
# array
a <- unclass(HairEyeColor)
dimlabels(a)
a2 <- undimlabel(a) # removes dimlabels from all dimensions
dimlabels(a2)
a3 <- undimlabel(a, dims = c(1,2)) # remove dimlabels from only the first and second dimenions
dimlabels(a3)
a4 <- undimlabel(a, dims = c("Hair","Eye"))
dimlabels(a4)
all.equal(a3, a4)
}
